package simpleIO;
import java.awt.*;
import java.awt.event.*;

abstract public class SimpleDialog extends Dialog implements ActionListener {
// for debugging implements FocusListener, ActionListener {
	
    protected SimpleGUI parent;

	protected boolean done = false;
	protected boolean quit = false;
	
	protected Button cancel,retry,accept;
	protected TextField response;
	
	protected String promptString;
	
	public SimpleDialog(SimpleGUI frame,String p) {
		super(frame);
   
		parent=frame;
		promptString = p;

		setBackground(parent.getColor());
		setFont(parent.getFrameFont());
	}


    abstract protected void setUpDialog();
    
  protected void buildDialogPicture(Component mainComponent,Label prompt){
    add(prompt,BorderLayout.NORTH);
    buildDialogPicture(mainComponent);
  }
  protected void buildDialogPicture(Component mainComponent){
    add(mainComponent,BorderLayout.CENTER);

    // make a button panel
    Panel p = new Panel();
    cancel = new Button("Cancel Input");
    retry = new Button("Clear Input");
    accept = new Button("Accept Input");
		
    p.add(cancel);
    p.add(retry);
    p.add(accept);
    add(p,BorderLayout.SOUTH);
 

    pack();
   
    // Calculate where to put the dialog box.
    Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    
    Rectangle historyBounds = parent.getBounds();
    Rectangle dialogBounds = getBounds();
    if (screenDim.width > ( historyBounds.width + dialogBounds.width + 15))
      setLocation(historyBounds.width+15,historyBounds.y);
    else setLocation(screenDim.width - dialogBounds.width - 10,10);

 
    setResizable(false); 
    show();		   
  }
	synchronized protected void wakeMasterThread() {
		done = true;
		notify();
	}
	synchronized protected void waitForGoodInput() {
		while(! done) {
			
			try { 
				wait();
				if (quit) parent.exitGracefully();
			} catch(InterruptedException e) { 
				System.err.println("Unexpected interruptedException " + e);
			}
		}
	}
	
/* !!! For debugging purposes 
	public void focusGained(FocusEvent evt) {
		// .println("FOCUS_GAINED: " + evt.getComponent().getName());
	}
// !!! For debugging purposes		
	public void focusLost(FocusEvent evt) {
		// ("FOCUS_LOST: " + evt.getComponent().getName());
	}
	
*/	
	protected void addListeners() {
			
	
	    cancel.addActionListener(this);
		retry.addActionListener(this);
		accept.addActionListener(this);
	// !!! For debugging purposes	

    // addFocusListener(this);
	}
	
	protected void removeListeners() {
	
		cancel.removeActionListener(this);
		retry.removeActionListener(this);
		accept.removeActionListener(this);
	
	//	removeFocusListener(this);
	}	

abstract public void actionPerformed(ActionEvent e); 
} // TextDialog
		
