
/* SimpleGUI class, called by novice application programs to do GUI-based I/O.

   Design by Ursula Wolz and Elliot Koffman
   
   Implementations:
   Version 3.  U. Wolz, August 1998
   Version 2.  U. Wolz, Michael McAuliffe, March 1998
   Version 1.5 Brice Berhinger, Greg Bronevetsky, George Drayer, 
               Bill Fenstermaker, Mark Nikolsky, Mike Sipper, December 1997
   Version 1.0 Lana Kucherovsky,  August 1997
*/


package simpleIO;
import java.awt.*;
import java.awt.event.*;


public class SimpleGUI extends Frame implements WindowListener, ActionListener {
// Datafields

	// Window detials:
	//    Quit. Print and Save will be added later (maybe)
	//    Save Interaction History (from Mike's code.)
	//    Print (from Mike's code.)
/* !!! */
	// Extras:  change font size
	private MenuItem quit = new MenuItem("Quit");
	private Choice menu; // for makeMenu/getChoice combination below

	// gui objects 
    private TextArea history;
    private SimpleGraphic drawingSurface;
    
    // Display preference defaults.
    public static final String		BANNER = "User Interaction History";
    public static final Font 		FONT	 =  new Font("Dialog",Font.PLAIN,12);
    public static final Color 		BACKGROUND = Color.white;
    public static final Point 		HISTORYLOC = new Point(10,5);
    // Might want to consider making this screen size relative right from the start.
    public static final Dimension 	HISTORYSIZE = new Dimension(300,200);
    public static final char		TABLEDELIMITER = '\t';
    
    // Preference variables:
    private String banner; 
    private Font font;  
    private Color background; 
    private Point historyLoc; 
    private Dimension historySize; 
    private char tableDelimiter;
    
    // History variable:
    private int columnWidth = 0;

// Constructors 
 	public SimpleGUI() {
    	this(BANNER,FONT,BACKGROUND,HISTORYLOC,HISTORYSIZE);
    }
    
    public SimpleGUI(String b) {
    	this(b,FONT,BACKGROUND,HISTORYLOC,HISTORYSIZE);
    }
    
    public SimpleGUI(String b, Font ft,Color bk, Point hl, Dimension hs) {
    	super(b);
    	banner = b;
    	font = ft;
    	background = bk;
    	historyLoc = hl;
    	historySize = hs;
    	
    	// How are you going to control the font size of the banner?
    	
    	setBackground(background);
    	setFont(ft);
    	
    	// Build menu bars
    	buildMenuBars(font);
    	
	 	// Create History area. 
	 	// Note the layout, is this the best for this purpose? 
        history = new TextArea();
		history.setEditable(false);
    	add(history);
    	
    	tableDelimiter = TABLEDELIMITER;
    	
    	// Create window.
    	Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    	if (historySize.width > screenDim.width) historySize.width = screenDim.width/3;
    	if (historySize.height > screenDim.height) historySize.height = screenDim.height/3;
    	setSize(historySize);	
    	setLocation(historyLoc);

    	show();

    	// Then set font.
    }	
// Accessors and general tools    
    Color getColor() { return background;}
    Font getFrameFont() {return font;}

    
    // Window menus!!!! Modify
    private void buildMenuBars(Font font) {
		// Need to create fonts of the proper size in here for menu's!
    	MenuBar bar = new MenuBar();
	 	Menu m = new Menu("File");
	 	m.add(quit);
	 	quit.addActionListener(this); 
	 	bar.add(m);
	 	setMenuBar(bar);
		addWindowListener(this);
	}
	

// displayResult
    public void displayResult(String text) {
    	history.append(text + "\n");
    }
    
    public void displayResult(char text) {
    	history.append(text + "\n");
    }
    public void displayResult(double text) {
    	history.append(text + "\n");
    }
    public void displayResult(int text) {
    	history.append(text + "\n");
    }
    public void displayResult(boolean text) {
    	history.append(text + "\n");
    }


// getDouble
    public double getDouble(String prompt) {
    	return getDouble(prompt, - Double.MAX_VALUE,Double.MAX_VALUE);
    }
    
    public double getDouble(String prompt,double lowerBound, double upperBound) {	
       	DoubleDialog d = new DoubleDialog(this,prompt,lowerBound,upperBound);
   		double r =  d.getResult();
   		history.append(prompt + "\n" + r + "\n");
   		return r;
	}	

// getInt        
    public int getInt(String prompt) {
    	return getInt(prompt, - Integer.MAX_VALUE,Integer.MAX_VALUE);
    }
    
    public int getInt(String prompt,int lowerBound, int upperBound) {	
       	IntDialog d = new IntDialog(this,prompt,lowerBound,upperBound);
   		int r = d.getResult();
   		history.append(prompt + "\n" + r + "\n");
    	return r;
        }
      	
// getChar
    public char getChar(String prompt) {
    	return getChar(prompt,Character.MIN_VALUE,Character.MAX_VALUE);
    }
    
    public char getChar(String prompt,char lowerBound, char upperBound) {	
       
   		CharDialog d = new CharDialog(this,prompt,lowerBound,upperBound);
   		char r = d.getResult();
		history.append(prompt + "\n" + r + "\n");
    	return r;
        }
 	
// getString        
    public String getString(String prompt) {	
       
   		StringDialog d = new StringDialog(this,prompt);
   		String r = d.getResult();
		history.append(prompt + "\n" + r + "\n");
    	return r;
        }

// getBoolean        
    public boolean getBoolean(String prompt, String yes, String no) {
    	CheckGroupDialog d = new CheckGroupDialog(this,prompt, yes, no);
    	boolean r = d.getResult();
    	history.append(prompt + "\n");
    	if (r) history.append(yes + "\n");
		else history.append(no + "\n");
    	return r;
    }
    
  	public boolean getBoolean(String prompt) {
    	CheckBoxDialog d = new CheckBoxDialog(this,prompt);
    	boolean r = d.getResult();
    	history.append(prompt + "\n" + r + "\n");
    	return r;
    }
  
// Menu creation and control.
    public void createMenu() {
    	menu = new Choice();
    }
    
 	public void removeMenu() {
    	menu = null;
    }
    
    public void addChoice(String label) {
    	menu.add(label);
    }
		
	public int getChoice(String prompt) {
		MenuDialog m = new MenuDialog(this,prompt,menu);
    	int r = m.getResult();
    	String choiceStr = menu.getItem(r);
    	history.append(prompt + "\n" + choiceStr + "\n");
    	return r;}

// displayRow
// is over-loaded for int,boolean,char,double and String.

	public void displayRow(int a[]) {
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(int a[], int length) {
		displayRow(a,length,a.length,'\t',true);}
	 
	public void displayRow(int a[], int length, int offset) { 
		displayRow(a,0,offset,'\t',true);}
		
	public void displayRow(int a[], int length, int offset, char delimiter) { 
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(	int a[],int offset, int length, 
							char delimiter, boolean rightJustify) {
		String s[] = new String[a.length];
		for(int i = 0;i < s.length;i++) s[i] = a[i] + "";
		displayRow(s,offset,length,delimiter,rightJustify);
	}
	
	public void displayRow(double a[]) {
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(double a[], int length) {
		displayRow(a,length,a.length,'\t',true);}
	 
	public void displayRow(double a[], int length, int offset) { 
		displayRow(a,0,offset,'\t',true);}
		
	public void displayRow(double a[], int length, int offset, char delimiter) { 
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(	double a[],int offset, int length, 
							char delimiter, boolean rightJustify) {
		String s[] = new String[a.length];
		for(int i = 0;i < s.length;i++) s[i] = a[i] + "";
		displayRow(s,offset,length,delimiter,rightJustify);
	}
	
	public void displayRow(char a[]) {
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(char a[], int length) {
		displayRow(a,length,a.length,'\t',true);}
	 
	public void displayRow(char a[], int length, int offset) { 
		displayRow(a,0,offset,'\t',true);}
		
	public void displayRow(char a[], int length, int offset, char delimiter) { 
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(	char a[],int offset, int length, 
							char delimiter, boolean rightJustify) {
		String s[] = new String[a.length];
		for(int i = 0;i < s.length;i++) s[i] = a[i] + "";
		displayRow(s,offset,length,delimiter,rightJustify);
	}
	
	public void displayRow(boolean a[]) {
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(boolean a[], int length) {
		displayRow(a,length,a.length,'\t',true);}
	 
	public void displayRow(boolean a[], int length, int offset) { 
		displayRow(a,0,offset,'\t',true);}
		
	public void displayRow(boolean a[], int length, int offset, char delimiter) { 
		displayRow(a,0,a.length,'\t',true);}
	
	public void displayRow(	boolean a[],int offset, int length, 
							char delimiter, boolean rightJustify) {
		String s[] = new String[a.length];
		for(int i = 0;i < s.length;i++) s[i] = a[i] + "";
		displayRow(s,offset,length,delimiter,rightJustify);
	}
	
	public void displayRow(String a[]) {
		displayRow(a,0,a.length,'\t',false);}
	
	public void displayRow(String a[], int length) {
		displayRow(a,length,a.length,'\t',false);}
	 
	public void displayRow(String a[], int length, int offset) { 
		displayRow(a,0,offset,'\t',false);}
		
	public void displayRow(String a[], int length, int offset, char delimiter) { 
		displayRow(a,0,a.length,'\t',false);}
		

	private int columnMaxLength = 0;
	private int tableStart = 0;
	private int tableEnd = 0;
	
	
	public void displayRow(	String a[],int offset, int length, 
							char delimiter, boolean rightJustify) {
		
	
		if (delimiter != '\t') {
			columnMaxLength = 0;
		} else {
			// setFont
			if (!font.getName().equals("Monospaced")) {
				
				font = new Font("Monospaced",font.getStyle(),font.getSize());
				history.setFont(font);
			}
			int newMaxLength = findMaxLength(a);
			if (history.getCaretPosition() == tableEnd) {
				if (newMaxLength + 1 > columnMaxLength) {
					
					redisplayTable(padString(newMaxLength - columnMaxLength + 1));
					columnMaxLength = newMaxLength + 1;
				};
			}
			else {
				columnMaxLength = newMaxLength + 1;
				tableStart = history.getCaretPosition();
			}	
		};
	
		for(int i = offset; i< length;i++) {
			String temp =  padString(columnMaxLength - a[i].length() - 1);
			if (rightJustify) 
				history.append(temp + delimiter + a[i]);
			else
				history.append(a[i] + delimiter + temp);
		};  
		history.append("\n");
		
		if (delimiter == '\t') tableEnd = history.getCaretPosition();
	
	} // displayRow	
	
	private void redisplayTable(String padString){
		int pos = tableEnd;
		
		while ( pos > tableStart) {
			history.select(pos-1,pos);
			String item = history.getSelectedText();
			if (item.equals("\n")) 
				pos = pos - 1;
			else {
				if (item.equals("\t") || item.equals(" "))
					history.insert(padString,pos);
				else 
					history.insert(padString,pos-columnMaxLength);
				pos = pos - columnMaxLength;
			}
		}
	}
	
	private String padString(int size) {
		String temp =  "";
		for(int i = 0; i < size; i++)
			temp = " " + temp;
	
		return temp;
	}
	// findMaxLength
	private int findMaxLength(String a[]) {
		int maxLength = 0;
		for(int i = 0;i < a.length;i++) {
			if (a[i].length() > maxLength)	maxLength = a[i].length();
		};
		return maxLength;
	}

// Graphics
    public void showGraphic(SimpleGraphic ds) {
    	drawingSurface = ds;
    	int w = ds.getWidth();
    	int h = ds.getHeight();
    	
    	// This isn't right but it will do for now.
    	if ( w == 0 || h == 0) drawingSurface.setSize(100,100);
    	Panel p = new Panel();
    	p.setBackground(Color.gray);
    	p.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
    	p.add(drawingSurface);
    	add(p,BorderLayout.EAST);
    	
    	
    	int width;
    	int height;
    	Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    	Dimension historyDim = history.getSize();
    	Dimension dsDim = drawingSurface.getSize();
   
    	if (historyDim.width + dsDim.width + 10 > screenDim.width)
    		width = screenDim.width;
    	else width = historyDim.width + dsDim.width + 10;
    	if (historyDim.height > dsDim.height)
    		height = historyDim.height;
    	else height = dsDim.height + 10 ;
    	setSize(width,height);
    	
    	invalidate();
    	validate();
    }
	
// Dialog accessors and modifiers

// EVENT HANDLING CODE
    
    public void actionPerformed(ActionEvent e) {
	
		if (e.getSource() == quit) {
			exitGracefully();
		   }
	}
	

	void exitGracefully() {
		// eventually pop up dialog: save etc.
		// This is good enough for now. Next step is to kill all threads in thread group.
		dispose();
		try { 
			SecurityManager sec = System.getSecurityManager();
			if (sec != null) sec.checkExit(0);
			  System.exit(0);
		} catch(SecurityException e) {
			System.out.println("VM set to prohibit exit, can't go beyond output window, threads may still be running.");
			Thread.currentThread().stop();
		}
	}
	
	// Need a way to create pull the history window!
	public void windowClosing(WindowEvent e) {
	
		// eventually pop up a quit menu on this on?
		// exit gracefully from here?
		dispose();
	}
	
	// What do you want to do about these?
	public void windowActivated(WindowEvent e) {;}
	public void windowClosed(WindowEvent e) {;}
	public void windowDeactivated(WindowEvent e) {;}
	public void windowDeiconified(WindowEvent e) {;}
	public void windowIconified(WindowEvent e) {;}
	public void windowOpened(WindowEvent e) {;}
    
} // SimpleGUI


