package simpleIO;

import java.io.*;

public class SimpleReader extends BufferedReader  {
	
	public SimpleReader(String fileName)throws FileNotFoundException {
		super(new FileReader(fileName));
	}
	
	public double getDouble() throws IOException {
		String result = readLine();
		Double r;
		
		try {
			  r = Double.valueOf(result);
			  return r.doubleValue();
		} 
		catch(NumberFormatException e) {
			System.err.println(result + " is not a real number, returning 0");
			return 0;
		}
	}
	
	public int  getInt() throws IOException {
		String result = readLine();
		Integer  r;
		
		try {
			  r = Integer.valueOf(result);
			  return r.intValue();
		} 
		catch(NumberFormatException e) {
			System.err.println(result + " is not an integer  number, returning 0");
			return 0;
		}
	}
	
	public String getString() throws IOException {
		return readLine();
	}
	
	public char getChar() throws IOException {
		String result = readLine();
		if (result.length() != 1) { 
			System.err.println(result + " is not a single character, returning empty space");
			return ' ';
		} else
		return result.charAt(0);
	}
	
	public boolean getBoolean() throws IOException {
		String result = readLine();
		if (result.equals("true")) 
			return true;
		else if (result.equals("false"))
			return false;
		else { 
			System.err.println(result + " is not 'true' or 'false', returning false.");
			return false;
		}
	}	
		
	    
	
	public boolean EOF() throws IOException {
		mark(1);
		int i = read();
		reset();
		return (i == -1);
	}
}
