package simpleIO;
import java.awt.*;
import java.awt.event.*;

abstract public class TextDialog extends SimpleDialog implements TextListener {
	
	// The column number is based on the number of characters in the panel buttons.
	private final int columnNumber = 35;
	private final int columnAdd = 10; // value is arbitrary.

	protected TextField response;
	protected Label prompt;
	
	public TextDialog(SimpleGUI frame,String p) {
		super(frame,p);
	}
	
	protected void setUpDialog(){
	  // Label goes north. it is optional
	  // Main component goes center, it varies.
	  // All types have the three buttons at the bottom.

		prompt = new Label(promptString);
		response = new TextField(columnNumber);

		// overload this method: no prompt means nothing North.
		// Do ALL the layout work here, including show.
		buildDialogPicture(response,prompt);

		
		addListeners();
		response.requestFocus();
		waitForGoodInput();
		dispose();
		removeListeners();
	}	

	protected void addListeners() {
		super.addListeners();	
		response.addActionListener(this);
		response.addTextListener(this);
	
	// !!! For debugging purposes	
	//	response.addFocusListener(this);
	//	addFocusListener(this);
	}
	
	protected void removeListeners() {
		super.removeListeners();
		response.removeActionListener(this);
		response.removeTextListener(this);
	
	//	response.removeFocusListener(this);
	//	removeFocusListener(this);
	}
	protected abstract boolean validateResponse(String text); 
	
	public void textValueChanged(TextEvent e) {
		int cols = response.getColumns();

		if (response.getText().length() == cols) {
			response.setColumns(cols+columnAdd);
// !!! This may not work under UNIX.
			pack();
		}
	}
				
		
		
	public void actionPerformed(ActionEvent e) {
		
		if ((e.getSource() == response) || (e.getSource() == accept)) {
			if (validateResponse(response.getText()))
				wakeMasterThread();
			else {
				response.setText("");
				response.requestFocus();
			} 
		}
		else if (e.getSource() == retry) {
			response.setText("");
			response.requestFocus();
			}
			else { // source == cancel 
		
				BailDialog b = new BailDialog(this,getDefault());
             	if (b.reallyBail())
             		quit = true;
             	else
             		setDefault(); 	
             	wakeMasterThread();
			}
	}	
	
	protected abstract String getDefault();
	protected abstract void setDefault();
	
} // TextDialog
		
