/*	File: PricedCircle.java
	Developed for Problem Solving With Java, Koffman & Wolz
   	Appears in Figure 4.6
*/

import simpleIO.*;

public class PricedCircle extends SimpleGUI {
	// Data Fields
	private double radius;
	private double price;

	public void readPCircleData () {
		// Enter diameter and price.
		radius = getDouble("Diameter or size:") / 2;
		price = getDouble("Price $:");
	}

	public double computeArea () {
		return Math.PI * radius * radius;
		//return Math.PI * Math.pow(radius, 2);
	}

	public double computeUnitPrice() {
		return price / computeArea();
	}

	public void showPricedCircle() {
		displayResult("Size is " + 2 * radius);
		displayResult("Price is $" + price);
		displayResult("Unit price is $" + computeUnitPrice());
	}
} // Class PricedCircle


