/* FILE: HappyFace.java
   Developed for Problem Solving With Java, Koffman & Wolz
   Appears in Figure 4.32
*/

import java.awt.*;
import java.applet.Applet;

public class HappyFace extends Applet {
	
	// window dimensions
	int maxX = 500;   int maxY = 400;

    	// center of head and radius of head
    	int headX = maxX / 2;    int headY = maxY / 2;
    	int headRadius = maxY / 4;

    	// position of eyes and radius of eyes
    	int leftEyeX = headX - headRadius / 4;
    	int rightEyeX = headX + headRadius / 4;
    	int eyeY = headY - headRadius / 4;
    	int eyeRadius = headRadius / 10;

    	// position of nose and radius of nose
    	int noseX = headX;  int noseY = headY + headRadius / 4;
    	int noseRadius = eyeRadius;

    	// radius of smile
    	int smileRadius = (int) Math.round(0.75 * headRadius);
	
	public void paint (Graphics g) {
        	g.setColor(Color.black);

        	// Draw head.
        	g.drawOval(headX - headRadius, headY - headRadius,
                           2 * headRadius, 2 * headRadius);

        	// Draw left eye.
        	g.drawOval(leftEyeX - eyeRadius, eyeY - eyeRadius,
                           2 * eyeRadius, 2 * eyeRadius);

        	// Draw right eye.
        	g.drawOval(rightEyeX - eyeRadius, eyeY - eyeRadius,
                     	   2 * eyeRadius, 2 * eyeRadius);

        	// Draw nose.
        	g.drawOval(noseX - noseRadius, noseY - noseRadius,
                           2 * noseRadius, 2 * noseRadius);

        	// Draw smile
        	g.drawArc(headX - smileRadius, headY - smileRadius,
                  	   2 * smileRadius, 2 * smileRadius, 210, 120);

    }

} // Class HappyFace
