/* 	Demonstration application for SimpleGUI functionality.
	Consider this the "documentation."  
	Table 3.3 method calls are shown here, as 
	well as two flavors of getBoolean.
	
	Note: PS with Java extends SimpleGUI. Here we instantiate one
	directly
	
	Known annoyance: the dialog should request the focus, I ran
	out of time.
		   
	Goals for this version:	
	 1.Confirm that expected actions are possible. They are.
	 2.Get an example of visual effect. PLEASE provide feedback.
	 3.Icing" that will not directly impact prose, code or screen shots 
				are mostly not implemented yet.
				
	Advice when running: Pull down menu lets you quit. Please
	check this for me on PC/Sun.  Test the HELL out of the dialog
	boxes (try all the options!)
					  		
				
	U. Wolz, March 1998 */

import simpleIO.*;
public class DialogDemo {
	public static void main(String args[]) {
	
		// Create a SimpleGUI object.
		
		SimpleGUI test = new SimpleGUI();
		
		// displayResult(String) is shown repeatedly below
		
		// getDouble with bounds.
		double d = test.getDouble("Hi Jim, How old are you:",0,200);
		test.displayResult("You were born in " + (1998 - d));
		
		// getDouble without bounds.
		d = test.getDouble("Hi Caryn, How old are you:");
		test.displayResult("You were born in " + (1998 - d));
		
		// getInt with bounds.
		int i = test.getInt("Hi Elliot, How old are YOU?", 0,200);
		test.displayResult("You were born in " + (1998 - i));
		
		// getInt with bounds.
		i = test.getInt("Hi Elliot, How old are YOU?");
		test.displayResult("You were born in " + (1998 - i));
		
		// getChar with bounds.	
		char c = test.getChar("Just one char please",'a','z');
		test.displayResult("You typed the letter " + c);
		
		// getChar without bounds.	
		c = test.getChar("Just one char please");
		test.displayResult("You typed the letter " + c);

		// getString
		String s = test.getString("Type some text please");
		test.displayResult("You typed " + s);
	
		// Sorry Elliot, I couldn't help doing these as composite functions.......
		// You may assign them to boolean variables if you MUST 
		// getBoolean as a checkbox group
		// boolean getBoolean(String prompt, String trueBoxPrompt, String falseBoxPrompt)
		if (test.getBoolean("Are you married?","Yes","No"))
			test.displayResult("Marriage is a good thing!");
		else test.displayResult("Being single is a cool thing!");
		
		// getBoolean as a single check box.
		// boolean getBoolean(String prompt)
		if (test.getBoolean("Have kids?"))
			test.displayResult("Kids are good");
		else test.displayResult("Kids are WORK!");	
	}
}
