/*	File: EditableString.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 5.18
*/

import simpleIO.*;

public class EditableString extends SimpleGUI {
	// Data fields
	private int editOp;   // input - edit operation
	private String text;  // input - text being edited

	// Methods
	public void readEditString() {
		text = getString("Enter string to edit:");
	}

	public void buildEditMenu() {
		createMenu();    // Create an empty menu.

		// Define the list of choices.
		addChoice("Search");
		addChoice("Insert");
		addChoice("Delete");
		addChoice("Replace");
		addChoice("Quit");
	}

	public void doEditOperation() {
		switch (editOp) {
			case 0:
				search();
				break;
			case 1:
				insert();
				break;
			case 2:
				delete();
				break;
			case 3:
				replace();
				break;
			case 4:
				displayResult("All done");
				break;
			default:
				displayResult("Invalid operation.");
		}
	}


	// Searches editString for a target string.
	public void search() {
		String target = getString("Enter string to find:");
		int index = text.indexOf(target);

		if (index >= 0)
			displayResult("String '" + target + 
						"' starts at position " + index);
		else
			displayResult("String not found ");
	}

	// Inserts a substring in editString.
	public void insert() {
		String newString = 
					getString("Enter string to insert:");
		int index = getInt("Enter index of insertion point:",
						0, text.length());

		// Join string before index, newString, and 
		//	string after index.
		text = text.substring(0, index) + newString + 
				text.substring(index);
	}


	// Deletes a substring of editString.
	public void delete() {
		String out = getString("Enter string to delete:");
		int posOut = text.indexOf(out);  //Find starting position

		if (posOut >= 0)
			// Join string before out and string after out
			text = text.substring(0, posOut) +
					text.substring(posOut + out.length());
		else
			displayResult("String not found " + 
						"- no deletion performed");
	}


	// Replaces one substring of editString with another.
	public void replace() {
		String out = getString("Enter string to replace:");
		String newString =
					getString("Enter replacement string:");
		int posOut = text.indexOf(out);  //Find starting position

		if (posOut >= 0)
			// Join string before out, newString, 
			//	& string after out
			text = text.substring(0, posOut) + newString +
					text.substring(posOut + out.length());
		else 
			displayResult("String not found " +
						"- no replacement performed");
	}

	public void showEditOperation() {
		buildEditMenu();
		editOp = getChoice("Choose an edit operation");
		doEditOperation();
		displayResult("Edit string is: " + text);
	}

} // class EditableString

