/*	File: Company.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 6.5
*/
import simpleIO.*;

public class Company extends SimpleGUI {
     // Data fields
     private int numberEmp;     // input - number of employees
     private double totalGross; // output - total gross pay
     private double totalNet;   // output - total net pay

     // Methods
     public void computePayTotals() {
          //Local data
          double gross;     // gross pay for an employee
          double net;       // net pay for an employee

          // Create an Employee object
          Employee gardener = new Employee();

          // Compute each employee's gross pay & net pay
          //   and add it to totals.
          int countEmp = 0;          // no employees processed
          while (countEmp < numberEmp) { 

             // Get employee data.
             gardener.enterEmpData();

             // Compute gross pay and net pay.
             gross = gardener.computeGross();
             net = gardener.computeNet(gross);

             // Display gross pay and net pay.
             gardener.displayResult("Employee gross pay is $"
                                      + gross);
             gardener.displayResult("Employee net pay is $" +
                                      net + "\n");

             // Add gross pay and net pay to totals.
             totalGross += gross;
             totalNet += net;

             // Add one to count of employees processed.
             countEmp++;
          }
     } // computePayTotals


     public void readNumberEmp () {
          numberEmp = getInt("Enter number of employees:");
     }

     public void displayPayTotals() {
        // Compute total gross pay and total net pay.
          computePayTotals();

          displayResult("\nNumber of employees is " + numberEmp);
          displayResult("The total gross pay is $" + totalGross);
          displayResult("The total net pay is $" + totalNet);
     }
} // class Company
