/*	File: TempTable.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 6.16
*/

import simpleIO.*;

public class TempTable extends SimpleGUI {
	//Data fields
	private int minCelsius;  // smallest Celsius temp value
	private int maxCelsius;  // largest Celsius temp value
	private int stepCelsius; // change in Celsius values

	//Methods
	public void readTableLimits() {
	   minCelsius = getInt("Enter min Celsius temperature:");
	   maxCelsius = getInt("Enter max Celsius temperature:", 
	                       minCelsius, 1000);
	   stepCelsius = getInt("Enter change in Celsius temp " +
	                        "between table lines:");
	}


	public double toFahrenheit(int celsius) {
	   return 1.8 * celsius + 32;
	}


	public void showTempTable() {
	   // Display table heading and blank line.
	   displayResult("\nTable of Celsius and " +
	                 "Fahrenheit temperatures\n");
	   displayResult("Celsius" + "\t" + "Fahrenheit");

	   // Display the table rows.
	   for (int celsius = minCelsius; celsius <= maxCelsius;
	        celsius += stepCelsius)
	      displayResult(celsius + "\t" + 
                        toFahrenheit(celsius));
	}

} // class TempTable
