/*	File: VaryingQuilt.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 6.22
*/

import simpleIO.*;
import java.awt.*;

public class VaryingQuilt extends SimpleGraphic {

	//Data Fields
	int maxX = 600;   //window size in horizontal direction
    	int maxY = 500;   //window size in vertical direction
   	int numRecs = 15; // Default value for num of rectangles
    	int numColors = 10;       // number of colors

    	//Methods

    	// Modifier for data field numRecs
    	public void setNumRects(int rn ) {
		if  (rn < 1 || rn > 20) 
			numRecs = 15;
		else 
			numRecs = rn;
    	}

    	// Returns one of 11 standard colors
    	private Color defineColor (int i) {
        	switch (i) {
            		case 0: return Color.black;
            		case 1: return Color.blue;    
            		case 2: return Color.cyan;    
            		case 3: return Color.gray;    
            		case 4: return Color.green;   
            		case 5: return Color.magenta; 
            		case 6: return Color.orange;  
            		case 7: return Color.pink;
            		case 8: return Color.red;
            		case 9: return Color.white;
            	default: return Color.yellow;
        	}
    	}

    	public void paint (Graphics g) {
        	int x1 = 0;	//starting x-coordinate
        	int y1 = 20;	//starting y-coordinate
        	int stepX = maxX / (2 * numRecs);   //change in x-coordinate
        	int stepY = maxY / (2 * numRecs);   //change in y-coordinate

        	int width = maxX;		//width of outermost rectangle
        	int height = maxY - 20;	//height of outermost rectangle
        	for (int i = 0; i < numRecs; i++)
        	{
          		g.setColor(defineColor(i % numColors)); //select next color
          		g.fillRect(x1, y1, width, height);//draw a filled rectangle
          		x1 += stepX;			//increment x-coordinate
          		y1 += stepY;			//increment y-coordinate
          		width -= 2 * stepX;		//decrement width of rectangle
          		height -= 2 * stepY;		//decrement height of rectangle
        	}
    	}

} // class VaryingQuilt


