/*	File: Exam.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 7.9
*/

import simpleIO.*;
import simpleMath.*;    // for computeMedian

public class Exam extends SimpleGUI {

	// Data Fields
	private int[] scores;  // scores is an array of ints

	// Methods
	public void getExamData() {
		// Allocate storage for the array.
		scores = 
			new int[getInt("How many students took the exam?")];
		
		//Read the scores
		for (int i = 0; i < scores.length; i++)
			scores[i] = getInt("Score for student " + i +":");
	}

	public void showStats() {
		// Compute statistics if array is created.
		if (scores.length > 0) {
			displayResult("student" + "\t" + "score");
			for (int i = 0; i < scores.length; i++)
				displayResult("" + i + "\t" + scores[i]);

			displayResult("\n" + "Minimum score:      " 
				+ findMin());

			displayResult("\n" + "Maximum score:      " 
				+ findMax());

			// Save mean for standard deviation.
			double mean = computeMean();
				displayResult("\n" + "Mean score:         "
				+ mean);

			displayResult("\n" + "Median score:       "
				+ computeMedian());

			displayResult("\n" + "Standard deviation: " 
				+ computeStandDev(mean));
		} else 
			displayResult("No students entered, so no stats!");
	} // showStats

	public int findMin() {
		int minSoFar = scores[0];
			for (int i = 0; i < scores.length; i++)
				if (scores[i] < minSoFar) minSoFar = scores[i];
		return minSoFar;
	}

	public int findMax() {
		int maxSoFar = scores[0];
			for (int i = 0; i < scores.length; i++)
				if (scores[i] > maxSoFar) maxSoFar = scores[i];
		return maxSoFar;
 }

	public double computeMean() {
		int sum = 0;
		for (int i = 0; i < scores.length; i++)
			sum += scores[i];
		return (double)sum / (double)scores.length;
	}

	// Computes standard deviation.
	// Requires the mean score as its argument.
	public double computeStandDev(double mean) {
		// Compute sum of scores-squared
		int sumSquares = 0;
		for (int i = 0; i < scores.length; i++)
  			sumSquares += scores[i] * scores[i];

		return 
		 Math.sqrt( sumSquares  / (double)scores.length  - mean * mean);
	}


	// Computes the median value.
	// Uses method findMedian (Fig. 7.19) in class IntArray.
	public int computeMedian() {
		return IntArray.findMedian(scores);
 	}

} // class Exam

