/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.13.

   Returns true if its array arguments are equal.
   Returns false if they are not.
*/
     public static boolean sameArray(int[] a, int[] b) {
        // Check for unequal lengths.
        if (a.length != b.length)
           return false;

        // Return false if any pair doesn't match.
        for (int i = 0; i < a.length; i++)
           if (a[i] != b[i])
              return false;

        // All pairs matched.
        return true;
     }
