/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.15.

   Returns a reference to an array that contains the sum of 
   corresponding pairs of elements of its array arguments.
   The first element in the result array is a[0] + b[0],
   the second element is a[1] + b[1], ... .
*/
public static int[] addArray(int[] a, int[] b) {
   int[] c = new int[Math.min(a.length, b.length)];

   for (int i = 0; i < c.length; i++)
      c[i] = a[i] + b[i];

   return c;
}
