/*	File: Employee.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 5.12
*/

import simpleIO.*;

public class Employee extends SimpleGUI {
	// Data fields
	private double hours;
	private double rate;

	// Methods
	// Enters employee data
	public void enterEmpData() {
		// Enter hours and rate.
		hours = getDouble("Hours worked:");
		rate = getDouble("Hourly rate $");
	}

	// Computes gross pay.
	public double computeGross() {
		// Local variables ...
		double maxNoOvertime = 40; // hours in work week
		double overtimeRate = 1.5; // overtime rate

		// Compute gross pay.
		if (hours <= maxNoOvertime)
			return hours * rate;
		else {
			double regularPay = maxNoOvertime * rate;
			double overtimePay = (hours - maxNoOvertime) * 
						overtimeRate * rate;
			return regularPay + overtimePay;
		}
	}

	// Computes net pay.
	public double computeNet(double gross) {
		// Local variables
		double maxNoDues = 100;	// max earnings before dues
		double dues = 25;		// dues amount

		// Compute net pay.
		if (gross <= maxNoDues)
			return gross;
		else
			return gross - dues; // deduct dues amount

	}

	// Shows employee information.
	public void showEmp() {
		// Local variables
		double gross = computeGross();  // Store gross pay.

		displayResult("Hours worked are " + hours);
		displayResult("Hourly rate is $" + rate);
		displayResult("Gross salary is $" + gross);
		displayResult("Net salary is $" + computeNet(gross));
	}

} // Class Employee
