/*	File: NewCompany.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 7.20 and Fig. 7.25
*/

import simpleIO.*;

public class NewCompany extends SimpleGUI {

	// Data fields
	private Employee[] employees; // array of employees
	private double totalGross;

	// Methods
	// Reads employee data.
	public void readAllEmpData() {
		// Create array of Employee references.
		employees = new Employee[getInt("Number of employees")]; 

		for (int countEmp = 0; 
			countEmp < employees.length;
			countEmp++) {
			// Create a new Employee object and reference
			//   it through employees[countEmp]
			employees[countEmp] = new Employee();
			employees[countEmp].enterEmpData();
		}
	}

	// Computes total gross pay.
	public void computeTotalGross() {
		totalGross = 0;
		for (int countEmp = 0;
			countEmp < employees.length;
			countEmp++)
			   totalGross += 
			      employees[countEmp].computeGross();
	}

	// Computes mean gross pay.
	public double computeMeanGross() {
		if (employees.length != 0 && totalGross != 0)
			return totalGross / employees.length;
		else
			return 0.0;
	}

	// Computes median gross pay.
	// See programming exercise 1.
	public double computeMedianGross() {
		displayResult("Method computeMedianGross coming");
		return -1;   // Return a value.
	}

	public void showPayroll() {
    computeTotalGross();
		displayResult("Total gross pay is $" +
					totalGross);
		displayResult("Mean gross pay is $" +
					computeMeanGross());
		displayResult("Median gross pay is $" +
					computeMedianGross());
	}

} // class NewCompany
