/*	File: NewCompany.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 7.20 and 7.25.
*/

import simpleIO.*;
import java.io.*;

public class NewCompany extends SimpleGUI {
	// Data fields
	private Employee [] employees;
	private double totalGross;

	// Methods
	// Reads employee data.
	public void readAllEmpData() {
		// Create array of Employee references.
		employees = new Employee[getInt("Number of employees")]; 

		for (int countEmp = 0; 
			countEmp < employees.length;
			countEmp++) {
			// Create a new Employee object and reference
			//   it through employees[countEmp]
			employees[countEmp] = new Employee();
			employees[countEmp].enterEmpData();
		}
	}

	// Computes total gross pay.
	public void computeTotalGross() {
		totalGross = 0;
		for (int countEmp = 0;
			countEmp < employees.length;
			countEmp++)
			   totalGross += 
			      employees[countEmp].computeGross();
	}

	// Computes mean gross pay.
	public double computeMeanGross() {
		if (employees.length != 0 && totalGross != 0)
			return totalGross / employees.length;
		else
			return 0.0;
	}

	// Computes median gross pay.
	// See programming exercise 1.
	public double computeMedianGross() {
		displayResult("Method computeMedianGross coming");
		return 0.0;   // Return a value.
	}

	public void showPayroll() {
		displayResult("Total gross pay is $" +
					totalGross);
		displayResult("Mean gross pay is $" +
					computeMeanGross());
		displayResult("Median gross pay is $" +
					computeMedianGross());
	}

	// Methods for file input/output
	// Writes array size and data to a file.
	public void writeArrayToFile() {
		try {
			SimpleWriter outFile =  
					new SimpleWriter("EmployeeData");

			// Save the length of the array.
			outFile.putData(employees.length);

			// Write the array data.
			for (int i = 0; i <= employees.length; i++) {
				// tell employee i to put data in outFile
				employees[i].saveData(outFile); 
			outFile.close();
			}

		} catch (FileNotFoundException e) {
			System.err.println(
					"EmployeeData file not found");
		}  catch (IOException e) {
			e.printStackTrace();
		}
	} // writeArrayToFile


	// Reads array size and data from a file.
	public void readDataFromFile() {
		try { 
			SimpleReader inFile = 
					new SimpleReader("EmployeeData");

			// Read the length of the array and
			//   the array data.
			int arraySize = inFile.getInt();
			if (arraySize <= 0) 
				System.err.println("Bad array size");
			else { // Read the array data.
				int count = 0;
				while ((count < arraySize) && 
						!inFile.EOF()) {
					employee[count].loadData(outFile);
					count++;
				}

				// Check for incorrect number of values.
				if (count != arraySize) { 
					// Reached end of file unexpectedly
					System.err.println(
							"Not all data read!");
				}
			inFile.close();
			}

		} catch (FileNotFoundException e) {
			System.err.println(
					"EmployeeData file not found");
		} catch (IOException e) {
			e.printStackTrace();
		}
	} // readDataFromFile

} // class NewCompany
