/*	File: PascalTriangle.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 7.30.
*/

import simpleIO.*;

public class PascalTriangle extends SimpleGUI {

	// Data field
	private int pascalTriangle[][];
	
	// Methods
	// Builds a Pascal triangle.

	public void buildTriangle() {
		pascalTriangle = 
       new int[getInt("How high should the triangle be?")][];

		// Start with the first row.
		pascalTriangle[0] = new int[1];
		pascalTriangle[0][0] = 1;
		
		// Build the remaining rows, one row at a time.
		int row = 1;
		while (row < pascalTriangle.length) {
			int lastRow[] = pascalTriangle[row-1];
			int newRow[] = new int[row+1];
		
			// Store 1 in the first and last elements of the row.
			newRow[0] = 1;
			newRow[newRow.length - 1] = 1;
			
			// Fill in the middle of the row.
			for(int i = 1;  i < (newRow.length - 1);  i++)
				newRow[i] = lastRow[i-1] + lastRow[i];
			
			pascalTriangle[row] = newRow;
			row++;
		}
	}
	

	// Display Pascal triangle - see programming ex. 1
//	public void showTriangle() {}

} // class PascalTriangle

