/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.13.

   Returns true if its array arguments are equal.
   Returns false if they are not.
*/
package simpleMath;

public class IntArray {

  private IntArray() {}

     public static boolean sameArray(int[] a, int[] b) {
        // Check for unequal lengths.
        if (a.length != b.length)
           return false;

        // Return false if any pair doesn't match.
        for (int i = 0; i < a.length; i++)
           if (a[i] != b[i])
              return false;

        // All pairs matched.
        return true;
     }

/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.15.

   Returns a reference to an array that contains the sum of 
   corresponding pairs of elements of its array arguments.
   The first element in the result array is a[0] + b[0],
   the second element is a[1] + b[1], ... .
*/
public static int[] addArray(int[] a, int[] b) {
   int[] c = new int[Math.min(a.length, b.length)];

   for (int i = 0; i < c.length; i++)
      c[i] = a[i] + b[i];

   return c;
}

/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.16.

   Searches for target in its array argument.
   Returns the index of the first occurrence or -1 if 
   target is not found.
*/
    public static int search(int[] x, int target) {
        for (int i = 0; i < x.length; i++)
            if (x[i] == target)
                return i;        //index of target

        // All elements tested without success.
        return -1;
    }

/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.18.

   Sorts the data in its array argument so that the
   values in the array are in increasing order.
   Calls method findPosMin
*/
public static void selectSort(int[] x) {

   int posMin;       //index of next smallest element
   int temp;         //temporary value for exchange

   for (int fill = 0; fill < x.length-1; fill++) {
      /* invariant:
            The elements in x[0] through x[fill-1] are in
            their proper place and fill < x.length.
      */
      //Find index of smallest element in subarray 
      //  starting at element x[fill].
      posMin = findPosMin(x, fill);

      //Exchange elements with indices fill and posMin.
      if (posMin != fill) {
        temp = x[fill];
        x[fill] = x[posMin];
        x[posMin] = temp;
      }
   }
}


public static int findPosMin(int[] x, int fill) {
   int posMinSoFar = fill;
   for (int i = fill + 1; i < x.length; i++)
      if (x[i] < x[posMinSoFar])
         posMinSoFar = i;

   return posMinSoFar;
}


/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.19.

   Returns the median value in its array argument.
*/
public static int findMedian(int x[]) {
	// Create a copy of array x.
	int[] copyX = new int[x.length];
	System.arraycopy(x, 0, copyX, 0, x.length); 

	selectSort(copyX);  // Sort array copyX

	return copyX[x.length / 2];
}

}

