/*	File: DrawableRect.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.4
*/

import java.awt.*;

public class DrawableRect extends IntRectangle {

	// Data fields
	private Point pos;  // input -the position of top-left corner
	private Color borderColor;   // input - the border color
	private Color interiorColor; // input - the interior color

     	// Methods
     	// Constructors
	public DrawableRect(int w, int l, Point p, Color b, Color i) {
		super(w, l);  // Define width and length fields
		pos = p;
		borderColor = b;
		interiorColor = i;
	}

	public DrawableRect() {}
	
	// Accessors
	public Point getPos() {return pos;}
	public Color getBorderColor() {return borderColor;}
	public Color getInteriorColor() {return interiorColor;}
	
	// Modifiers 
	public void setBorderColor(Color c) {borderColor = c;}
	public void setInteriorColor(Color c) {interiorColor = c;}
	public void setPoint(Point p) {pos = p;}

	// Operations
     	// Draw a rectangle.
	public void drawMe(Graphics g) {
		g.setColor(interiorColor);
		g.fillRect(pos.x, pos.y, getWidth(), getLength());
		g.setColor(borderColor);
		g.drawRect(pos.x, pos.y, getWidth(), getLength());
	}

} // class DrawableRect

