/*	File: DrawableRect.java (Expanded Version)
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.13
*/


import java.awt.*;

public class DrawableRect extends IntRectangle {

	// Data fields
	private Point pos = new Point(0, 0);
	private Color interiorColor = Color.white;
	private Color borderColor = Color.black;

	// Methods
	// Constructors
	public DrawableRect(int w, int l, Point p, Color i, Color b ) {
		super(w, l);
		pos = p;
		interiorColor = i;
		borderColor = b;
	}

	public DrawableRect(int w, int l) {
		super(w, l);
	}
	
	public DrawableRect(int w, int l, int x, int y) {
		super(w, l);
		pos = new Point(x, y);
	}

	public DrawableRect(int w, int l, Color i, Color b) {
		super(w, l);
		interiorColor = i;
		borderColor = b;
	}
		
	public DrawableRect() {}
	
	// Accessors
	public Point getPos() { return pos;}
	public Color getBorderColor() { return borderColor;}
	public Color getInteriorColor() { return interiorColor;}
	public int getX() {return pos.x;}
	public int getY() {return pos.y;}

	// Modifiers 
	public void setBorderColor(Color c) { borderColor = c;}
	public void setInteriorColor(Color c) {interiorColor = c; }
	public void setPoint(Point p) {pos = p;}
	public void setPoint(int x, int y) {pos.x = x; pos.y = y;}
	public void setX(int x, int y) {pos.x = x;}
	public void setY(int y) {pos.y = y;}

	// Operations
	public void drawMe(Graphics g) {
		g.setColor(interiorColor);
		g.fillRect(pos.x, pos.y, width, length);
		g.setColor(borderColor);
		g.drawRect(pos.x, pos.y, width, length);
	}

} // class DrawableRect
