/*	File: IntRectangle.java (added diplay() method)
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.17
*/

package figures;

public class IntRectangle { 

	// Data Fields
	int width;     // input - essential attribute 
	int length;    // input - essential attribute 

	//constructors
	public IntRectangle() {};

	public IntRectangle(int w, int l) {
		width = w;
		length = l;
	}
  
	public IntRectangle(int side) {
		this(side, side);
	}

	// Modifiers
	
	// modifies the width data field
	public void setWidth(int w) {width = w;}

  	// modifies the length data field
	public void setLength(int l) {length = l;}

	// Accessors:
	// retrieves the value of width
	public int getWidth() {return width;}

	// retrieves the value of length
	public int getLength() {return length;}

	// Operations:
	// retrieves the value of area
	public int computeArea() {
		return length * width;
	}
	
	// retrieves the value of perimeter
	public int computePerimeter() {
		return 2 * length * width;
	}

	//Display an IntRectangle object
	public void display() {
		System.out.println("width is " + width);
		System.out.println("length is " + length);
		System.out.println("area is " + computeArea());
		System.out.println("perimeter is " + 
						computePerimeter());
	}


} // class IntRectangle
