/*	File: DrawableTri.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 8.33
*/

package figures;
import java.awt.*;

abstract public class DrawableTri extends Triangle { 

	// Data fields
	protected Color color = Color.white;
	protected Point pos = new Point(0, 0);

	// Methods
	// Constructor
	public DrawableTri(double b, double h, Point p, Color c){ 
		super(b, h);
		pos = p;
		color = c;
	}

	public DrawAbleTri() {}

	// Modifiers
	public void setColor(Color c) { color = c;}
	public void setPos(Point p) { pos = p;}
  
	// Accessors:
	public Color getColor() { return color;}
	public Point getPos() { return pos;}
  
	// Operations
	
	public void drawMe(Graphics g) { 
		g.setColor(color);
		g.fillPolygon(this.createPoly());
	}
	
	abstract protected Polygon createPoly();

 } // class DrawableTri
