/*	File: Rect.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.26
*/

package figures;

public class Rect extends GeoFigure {

     // Data Fields
	protected double width;     // input - essential attribute
	protected double length;    // input - essential attribute 
	
     // Methods
	// Constructors
	public Rect()
	{this(0, 0);}
	
	public Rect(double w, double l)
	{width = w; length = l;}

	// Modifiers
	public void setWidth(double w) { width = w;}
	public void setLength(double l) { length = l;}
		
	// Accessors:
	final public double getWidth() { return width;}

	final public double getLength() { return length;}
	
	public double computeArea() { return length * width;}
	
	public double computePerimeter() {return 2 * (length + width);}
	 
	public String toString()
	{ return "Rectangle:" + length + ", " + width; }

 } // class Rect

