/*	File: Triangle.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.29
*/

package figures;

public class Triangle extends GeoFigure {

	// Data Fields
	protected double base;     // input, essential attribute 
	protected double height;    // input, essential attribute 
	
  	// Methods
  	// Constructor
  	public Triangle(double b, double h)
    		{ base = b; height = h;}
    
  	public Triangle() {}
    
  	// Modifiers
  	public void setBase(double b) { base = b;}
  
  	public void setHeight(double h){ height = h;}
  
  	// Accessors:
  	final public double getBase() { return base;}

  	final public double getHeight() { return height;}
  
  	// Operations
  
  	public double computeArea()
  		{ return height * base / 2;}
  
  	public double computePerimeter()
  		{ return height + base +  Math.sqrt(height*height + base*base);}
                
  	public String toString()
  		{ return "Right Triangle: " + height + ", " + base;}
	 
} // Class Triangle

