/*	File: Patch.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.40
*/

import java.util.*;
import figures.*;
import java.awt.*;

class Patch { 
	Vector pieces = new Vector();

	// Constructors
	public Patch() {}

	public Patch(Patch p, Point corner) { 
		DrawFigure oldPiece, newPiece;
		Point pos;
	
		for(int i=0; i < p.size(); i++) { 
			oldPiece = p.getPieceAt(i);
			newPiece = oldPiece.copyMe();
			pos = newPiece.getPos();
			pos.translate(corner.x, corner.y);
			pieces.addElement(newPiece);
		}
	}

	// Modifiers    
	public void add(DrawFigure d) {
		pieces.addElement(d);
	}
  
	// Accessors 
	protected DrawFigure getPieceAt(int index) { 
		return (DrawFigure) pieces.elementAt(index);
	}
   
	public int size() { 
		return pieces.size();
	}  
  
	// Operations 
	public void drawMe(Graphics g) { 
		DrawFigure d;
		for(int i = 0; i < pieces.size(); i++) { 
			d = (DrawFigure)pieces.elementAt(i);
			d.drawMe(g);
		};
	}

	public double area(Color c) { 
		double area = 0;
		for(int i = 0; i < pieces.size(); i++) {
			DrawFigure dfPiece = (DrawFigure)pieces.elementAt(i);
			AreaPerimeter apPiece = (AreaPerimeter)pieces.elementAt(i);
			if (dfPiece.getColor() == c) area = area + apPiece.area();
		};
		return area;
	}        

} // Class Patch

