/*	File: Quilt.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.39
*/

import java.awt.*;
import java.util.*;
import java.applet.Applet;

class Quilt 
{private Point pos; // Starting position
 private int sizeInPatches; 
 private Patch[][] patches; 
  
 public Quilt(Patch p, Point corner, int patchSize, int quiltSize)
   { sizeInPatches = quiltSize;
     patches = new Patch[sizeInPatches][sizeInPatches] ;
     for (int r = 0; r < sizeInPatches; r++)
       for(int c = 0; c < sizeInPatches; c++)
         patches[c][r] = new Patch(p, new Point(c*patchSize + corner.x, 
                                                r*patchSize + corner.y));
   }
   
  protected void drawMe(Graphics g)
   {  for (int r = 0; r < sizeInPatches; r++)
       for(int c = 0; c < sizeInPatches; c++)
         patches[c][r].drawMe( g);
   }
   
  protected double area(Color c)
   { return sizeInPatches*sizeInPatches*patches[0][0].area(c);
   }

} // class Quilt
