/*	File: QuiltApplet.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.44
*/

import figures.*;
import java.awt.*;
import java.applet.Applet;

public class QuiltApplet extends Applet
{  Patch sample;
   Quilt quilt;
   int quiltSizeInPatches;
 
   Point areaDisplay; // Where the area display will start
   
   // A color array simplifies reference to colors.  
   Color c[] = {Color.gray, Color.darkGray, Color.white, Color.black};
   double area[] = new double[c.length];  // the amount of each color in quilt
  //  
   public void init()
   {  int size = 10;     // The size of a square piece in pixels.
      int patchSize = 4; // The patch defined will be 4 X 4 "squares" in size.
      Point corner = new Point(20,20);
      quiltSizeInPatches = 5;
      areaDisplay = new Point( size*patchSize*quiltSizeInPatches + 2*corner.x,
                               corner.y);
      
      // This simplifies the definition of the relative position of pieces.
      // Relative position can be referenced by the array indices rather than 
      // by the actual positions.  The patch created has its corner at 0,0.
      Point p[][] = new Point[patchSize][patchSize];
      
      for(int x = 0; x < patchSize;x++)
       for(int y = 0; y < patchSize;y++)
         p[x][y] = new Point(x*size, y*size);
         
      // This creates a patch 
      sample = new Patch();
      sample.add(new ULTri (  size,   size, p[0][0], c[3]));
      sample.add(new LRTri (  size,   size, p[0][0], c[2]));
      sample.add(new Rect  (  size, 2*size, p[0][1], c[1]));
      sample.add(new Square(          size, p[1][0], c[2]));
      
      sample.add(new URTri (  size,   size, p[3][0], c[2]));
      sample.add(new LLTri (  size,   size, p[3][0], c[3]));
      sample.add(new Rect  (2*size,   size, p[2][0], c[0]));
      sample.add(new Square(          size, p[3][1], c[3]));
      
      sample.add(new ULTri (  size,   size, p[3][3], c[2]));
      sample.add(new LRTri (  size,   size, p[3][3], c[3]));
      sample.add(new Rect  (  size, 2*size, p[2][2], c[1]));
      sample.add(new Square(          size, p[2][3], c[2]));
      
      sample.add(new URTri (  size,   size, p[0][3], c[3]));
      sample.add(new LLTri (  size,   size, p[0][3], c[2]));
      sample.add(new Rect  (2*size,   size, p[1][2], c[0]));
      sample.add(new Square(          size, p[0][2], c[3]));
      
    
      // Here is the quilt
      quilt = new Quilt(sample, corner, patchSize*size,quiltSizeInPatches);
      
      for(int i = 0; i < area.length; i++)
        area[i] = quilt.area(c[0]);
    } // Init
    
	public void paint( Graphics g ) {
	  // Draw the quilt
	  quilt.drawMe(g); 
	 
	  // Display the areas.
	  for(int i= 0; i < area.length; i++)
	   {g.setColor(c[i]);
	    g.fillRect(areaDisplay.x, areaDisplay.y + 20*i, 10,10);
	    g.setColor(Color.black);
	    g.drawString( area[i] + "pixels", areaDisplay.x + 20, 
                        areaDisplay.y + 10 + 20*i);
       }
     }  

} // class QuiltApplet

