/*	File: DrawFigure.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 8.41
*/
  
package figures;
import java.awt.*;

public abstract class DrawFigure {
  protected Color color;
  protected Point pos;

  DrawFigure() {}
  DrawFigure(Point p, Color c){pos = p; color = c;}

 // Accessors
  public Color getColor() {return color;}
  public Point getPos() { return pos;}

 // Modifiers
 // The move method of Point translates a point to a new position.
  public void putPos(int x, int y){pos.move(x, y);}
  public void putPos(Point p){pos = p;} 
  public void putColor(Color c){color = c;}; 

 // Drawing   
  abstract public void drawMe(Graphics g);
  abstract public DrawFigure copyMe();

} // Class DrawFigure

