/*	File: Rect.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.42
*/

package figures;
import java.awt.*;

public class Rect extends DrawFigure implements AreaPerimeter
{ // Data Fields
	protected double width;     // input, essential attribute
	protected double length;    // input, essential attribute 
	
  public Rect() {}
  
  public Rect(double l, double w, Point p, Color c) {super(p, c);
   width = w; length = l;
  }

 // Modifiers
  public void setWidth(double w) { width = w;}
  public void setLength(double l) { length = l;}
  
  // Accessors:
  final public double getWidth() { return width;}

  final public double getLength() { return length;}

  // Operations
  public double area()
  { return length * width;}
  
  public double perimeter()
	 { return 2 * (length + width);}
	 
  public String toString() {
	return "Rectangle:" + length + ", " + width + ", " +
				pos + ", " + color;
  }
  

   public void drawMe(Graphics g) { 
    Color temp = g.getColor(); // saves color temporarily
    g.setColor(color);
    g.fillRect(pos.x, pos.y,(int)width,(int)length);
    g.setColor(temp);
  }
  
   public DrawFigure copyMe()
   { return new Rect(length, width, 
                      new Point(pos.x, pos.y), color);}

 } // class Rect

