/*	File: Triangle.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 8.43
*/

package figures;
import java.awt.*;
abstract public class Triangle extends DrawFigure implements 
AreaPerimeter
{ // Data Fields
	protected double base;     // input, essential attribute 
	protected double height;    // input, essential attribute 
	
  // Constructor
  public Triangle(double b, double h, Point p, Color c)
    { super(p, c);
      base = b; height = h;}
    
  public Triangle() {}
    
  // Modifiers
  public void setBase(double b) { base = b;}
  public void setHeight(double h)	// modifies the height data field
  { height = h;}
  
  // Accessors:
  public double getBase() { return base;}
  public double getHeight() { return height;}
  
  // Operations
  
  public double area() { return height * base/2;}
  
  public double perimeter() { 
    return height + base + Math.sqrt(height*height + 
base*base);
  }
                
  public String toString() { 
    return "Right Triangle: " + height + ", " 
               + base + "," + pos + ", " + color;}
  
  public void drawMe(Graphics g)
  { Color temp = g.getColor();
    g.setColor(color);
    g.fillPolygon(this.createPoly());
    g.setColor(temp);
  }
  
  abstract protected Polygon createPoly();

 } // Class Triangle
