/*	File: ClickMe.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 9.14
*/

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class ClickMe extends Applet implements ActionListener{

  private Button  aButton = new Button("Click me");
  private int clickCount = 0;
  
  public void init() {
     //Add aButton to the Applet
     aButton.setBackground(Color.gray);
     add(aButton);
     //Register ClickMe as a listener for aButton
     aButton.addActionListener(this);
  }
    

  public void actionPerformed(ActionEvent e) {
    //Change color after each press
    if (aButton.getBackground() == Color.lightGray)
      aButton.setBackground(Color.gray);
    else
      aButton.setBackground(Color.lightGray);
   
    clickCount++;
    aButton.setLabel("Click count: " + clickCount);
    // declare that the layout is no longer valid
    aButton.invalidate();
    // have the applet re-do the layout.
    validate();
    }

} // class ClickMe

