/*	File: Ball.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 9.25
*/

import java.awt.*;

public class Ball extends Thread { 

	private Graphics g;
 	private int x, y;
  	private int speed;

  	private Color[] colors  = 
     		{Color.red, Color.green, Color.blue};

  	private int nextColor = 0;

  public Ball(Canvas c, int x, int y, int speed) { 
		this.x = x;
    		this.y = y;
    		this.speed = speed;
    		g = c.getGraphics();
  }

  public void run() { 

    drawNextFrame(); // draw one initially.
    while (true)
     { try { sleep(speed*1000);}
       catch(InterruptedException e) {};
       drawNextFrame();
     	}
   }

  public void drawNextFrame(){ 

    g.setColor(colors[nextColor]);
    g.fillOval(x,y,50,50); 
    nextColor = (nextColor + 1) % colors.length;
  } 

} // class Ball

