/*	File: Ball.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 9.29
*/

import java.awt.*;
import java.util.*;
import java.applet.*;

class Ball extends Thread { 
	private ManyBalls ap;
	private Graphics g;
  	private int x, y;
  	private int speed;

  	private Vector ballColors = new Vector();
 	private int  nextColor = 0;

  	private void parseColors() {
    		//Retrieve the value of each param tag that is of the form colorN
    		//   & store the corresponding color in ballColors.
    		for (int i = 1; ap.getParameter("color" + i) != null; i++)
		      	ballColors.addElement(parseAColor(ap.getParameter("color"+ i)));
		 

    		//At least 2 colors should be defined.
    		if (ballColors.size() == 0) {
       			ballColors.addElement(Color.red);
       			ballColors.addElement(Color.green);
    		}
    		else if (ballColors.size() == 1) {
       			ballColors.setElementAt(Color.red, 0);
       			ballColors.addElement(Color.green);
    		}
  	}


   	private Color parseAColor(String c) {
//  System.out.println("Color in parseAColor " + c);
   		if (c.equals("red"))  return Color.red;
      else if (c.equals("green"))  return Color.green;
      else if (c.equals("blue"))   return Color.blue;
      else if (c.equals("yellow")) return Color.yellow;
      else return Color.black;
   	} // parseAColor

  	public Ball(ManyBalls ap, int x, int y, int speed) { 
		this.ap = ap;
		this.x = x;
    		this.y = y;
    		this.speed = speed;
    		Canvas c = ap.getDisplay();
		g = c.getGraphics();
  	}
  
  	public void run() { 
    		parseColors();
    		drawNextFrame(); // draw first one.
    	while (true)
     	{ try { sleep(speed*1000);}
       	catch(InterruptedException e) {}
       	drawNextFrame();
     	}
   }

  public void drawNextFrame(){ 
    	g.setColor((Color)ballColors.elementAt(nextColor));
    	g.fillOval(x,y,50,50); 
    	nextColor = (nextColor + 1) % ballColors.size();
  } 

} // Class Ball








