/*	File: ManyBalls.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Figure 9.28
*/

// Need these for buttons etc.

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class ManyBalls extends Applet implements ActionListener {

   private Canvas display = new Canvas();
   private Button startStop = new Button("Start");
   private Ball balls[];

   public void init(){ 

     int numberOfBalls = parseBallCount();
     balls = new Ball[numberOfBalls];
     display.setSize(numberOfBalls*70,70);
     add(display);
     add(startStop);
     setSize(numberOfBalls*70+100,200);
     startStop.addActionListener(this);

   } // init()

   public void actionPerformed(ActionEvent e){ 

     if(startStop.getLabel() == "Start") {
        for(int i = 0; i < balls.length; i++) {
          balls[i] = new Ball(this,  70*i, 10, 1 + 5*i);
          balls[i].start();
        }
        startStop.setLabel("Stop");
      }
      else { 
        for(int i = 0; i < balls.length; i++)
         {balls[i].stop();};
        startStop.setLabel("Start");
        display.repaint();
	   }
	} // actionPerformed

   private int parseBallCount() {

     int numberOfBalls;
     try {numberOfBalls =  
              Integer.parseInt(getParameter("balls"));
         }
     catch (NumberFormatException e) { numberOfBalls = 2;}

     return numberOfBalls;
   }

	public Canvas getDisplay() {
		return display;
	}

} // ManyBalls



