/*	File: Banner.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.1
*/

import java.awt.*;

public class Banner extends Canvas {
	// Data fields
	private String message;
	private Color pen; 
	private int xSpace; 
	private int ySpace; 
	private FontMetrics fm;

	// Methods
	// Constructors
	public Banner(String s, Color p, Font font, int x, int y) {
		message = s;
		pen = p;
		setFont(font);
	
		fm = getFontMetrics(font);
		int xSize = fm.stringWidth(message) + 2 * xSpace;
		int ySize = fm.getHeight() + 2 * ySpace;
		setSize(xSize, ySize);
	}
	
	public Banner(String b) {
		this(	b,
			Color.black,
			new Font("Serif", Font.PLAIN,24),
			10,
			10);
	}
	
	// Operation
	public void paint(Graphics g) {
		g.setColor(pen);
		g.drawString(message, xSpace, ySpace + fm.getAscent());
	}

} // class Banner

