/*	File: CardDemo.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.9
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class CardDemo extends Applet implements ActionListener {
   Button first,prev,next,last;
   Panel displays;
   CardLayout cLayout;
    public void init() {
      
      // The applet has a border layout
      setLayout(new BorderLayout());

      // Create the buttons for controlling the card panel. 
      // The button panel defaults to a FlowManager
       Panel buttonP = new Panel();
       first = new Button("First");
       buttonP.add(first);
       prev = new Button("Previous");
       buttonP.add(prev);
       next = new Button("Next");
       buttonP.add(next);
       last = new Button("Last");
       buttonP.add(last);
       add(buttonP,BorderLayout.SOUTH);
  
       first.addActionListener(this);
       prev.addActionListener(this);
       next.addActionListener(this);
       last.addActionListener(this);

       // Create the card panel, and card layout	  
       displays = new Panel();
       for(int i = 1; i <= 5; i++) 
	 displays.add( new Banner("Picture " + i));
       cLayout = new CardLayout();
       displays.setLayout(cLayout);
       add(displays, BorderLayout.CENTER); 
 }	
	public void actionPerformed(ActionEvent e) {
		Button b = (Button)e.getSource();

		if (b == next)
			cLayout.next(displays);
		else if (b == prev)
			cLayout.previous(displays);
		else if (b == last)
			cLayout.last(displays);
		else if (b == first)
			cLayout.first(displays);
	}
} // class CardDemo


