/*	File: ColorText.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.11
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class ColorText extends Applet implements ActionListener { 
    private Banner displayArea;
	private Button reset;
	private TextField message;
	private List colors;  
	
	private final String defaultMessage = "Type a message";
	
	public void init() {
		// create GUI layout
		displayArea = 
		  new Banner(defaultMessage, new Font("Serif", Font.BOLD | Font.ITALIC,14));
		add(displayArea);
	
		reset = new Button("Reset");
		add(reset);
		
		message = new TextField(defaultMessage);
		add(message);

		// Display three rows, don't allow multiple selections
		colors = new List(3,false); 
		
		colors.addItem("Red");
		colors.addItem("Green");
		colors.addItem("Blue");
		add(colors);
		
		setSize(350,400);
		
		reset.addActionListener(this);
		message.addActionListener(this);
		colors.addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == reset) {
			 displayArea.setMessage(defaultMessage);
			 displayArea.resetColor();
			 message.setText(defaultMessage);
			}
		else if (e.getSource() == message) 
			displayArea.setMessage(message.getText());
		else { // get the color from the list
			   String color = colors.getSelectedItem();
			   if (color == "Red")
				displayArea.setColor(Color.red);
			   else if (color == "Green") 
				displayArea.setColor(Color.green);
			   else
				displayArea.setColor(Color.blue);
			  }
		displayArea.repaint();
	}

}

