/*	File: CalorieCounter.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.12
*/

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class CalorieCounter extends Applet implements ItemListener {
	Label calories;
	Food[] foods =
		{ new Food("8 oz. orange juice", 80),
		  new Food("1 cup black coffee", 0),
	        new Food("1 serving cornflakes with 1/2 cup skim milk", 120),
                new Food("1 delicious sugar coated donut", 600),
	        new Food("8 oz. of skim milk", 70),
	        new Food("2 slices white toast, lightly buttered", 200)
             };
	                
	public void init() {
	setLayout(new GridLayout(0, 1));
		for(int i = 0; i < foods.length; i++)
			foods[i].makeBox(this); 
	
	 calories = new Label("Calories: 0        ");
	 add(calories);
	}

	public void itemStateChanged(ItemEvent e) {
		int total = 0;
		for(int i = 0; i < foods.length; i++)
		 { Checkbox box = foods[i].getBox();
		   if ( box.getState() ) total += foods[i].getCalories();
		  }
		calories.setText("Calories: " + total);
	}
	
} // class CalorieCounter

