/*	File: MultipleChoiceBox.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.14
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class MultipleChoiceBox extends Applet implements ItemListener
{   private Label question;
	private Checkbox a1, a2, a3;
	private CheckboxGroup answers;
	private Label report;
	
	public void init() {
		question = new Label("Which one is the best programming language");
		add(question);
		
		answers = new CheckboxGroup();
		a1 = new Checkbox("Pascal", answers, false);
		a2 = new Checkbox("C++", answers, false);
		a3 = new Checkbox("Java",answers,false);
		
		Panel p = new Panel();
		p.add(a1);
		p.add(a2);
		p.add(a3);
		add(p);
		// leave space for long string
		report = new Label("____________________________________________"); 
		add(report);
		
		a1.addItemListener(this);
		a2.addItemListener(this);
		a3.addItemListener(this);
	}
	
	public void itemStateChanged(ItemEvent e) {
		if ( a3.getState()) {
			report.setText("Of course!, Java is just right!");
			a1.setEnabled(false); // Disable the buttons.
			a2.setEnabled(false);
			a3.setEnabled(false);
		}
		else if (a2.getState()) 
			report.setText("No, C++ is too hard!");
	 		else report.setText("No, Pascal is too easy");
		repaint();
	} 
} // class MultipleChoiceBox

