/*	File: MultipleChoice.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.18
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class MultipleChoice extends Applet implements ItemListener {
	private Label question;
	private Choice answers;
	private Label report;
	
	public void init() {
		question = new Label("Which one is the best programming language");
		add(question);
		
		answers = new Choice();
		answers.addItem("Pull down for choices");
		answers.addItem("Pascal");
		answers.addItem("C++");
		answers.addItem("Java");
		
		add(answers);
		answers.addItemListener(this);

		// leave space for long string
		report = new Label("______________________________________________"); 
		add(report);

	}
	
	public void itemStateChanged(ItemEvent e) {
		if (answers.getSelectedItem() == "Pull down for choices")
			report.setText("Try again!");
			else if (answers.getSelectedItem() == "Java") {
				report.setText("Of course!, Java is just right!");
				answers.setEnabled(false); // Disable the Choice
			}
			else if (answers.getSelectedItem() == "C++") 
				report.setText("No, C++ is too hard!");
				else report.setText("No, Pascal is too easy");
	}       
} // class MultipleChoice

