/*	File: ColorBars.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.20
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class ColorBars extends Applet implements AdjustmentListener
{  Canvas c;
    String [] colorNames = { "Red:   ", "Green: ", "Blue:  "}; 
    Scrollbar values [] = new Scrollbar[3];
    Label labels [] = new Label[3];
   
	public void init() {
		setLayout(new BorderLayout());
		c = new Canvas();
		c.setSize(50,50);
		c.setBackground(new Color(255,255,255));
		add(c,BorderLayout.CENTER);
	  
	    Panel barPanel = new Panel();
	    barPanel.setLayout(new GridLayout(0,1));
		for(int i = 0; i < 3; i++) {
		    labels[i] = new Label(colorNames[i] + 255);
		    barPanel.add(labels[i]);
		    values[i] = new Scrollbar(Scrollbar.HORIZONTAL,255,1,0,256);
		    barPanel.add(values[i]);
		  
		    
		    values[i].addAdjustmentListener(this);
		}
		add(barPanel, BorderLayout.NORTH);
 	}
	
	public void adjustmentValueChanged(AdjustmentEvent e)
	{ for(int i = 0; i < 3 ; i++)
	    labels[i].setText( colorNames[i] + values[i].getValue());
	  
	  c.setBackground(new Color (values[0].getValue(),
	 			    values[1].getValue(),
	  			    values[2].getValue())
	  		 );
	  c.repaint();
	}

}

