/*	File: ColorBars.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.22
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class ColorBars extends Applet implements ActionListener
{   Canvas c;
    String [] colorNames = { "Red:   ", "Green: ", "Blue:  "}; 
    TextField values [] = new TextField[3];
    Label labels [] = new Label[3];
   
	public void init() {
		setLayout(new BorderLayout());
		c = new Canvas();
		c.setSize(50,50);
		c.setBackground(new Color(255,255,255));
		add(c,BorderLayout.CENTER);
		
		Panel textPanel = new Panel();
		textPanel.setLayout(new GridLayout(0,1));
	 	for(int i = 0; i < 3; i++) {
		    labels[i] = new Label(colorNames[i]);
		    textPanel.add(labels[i]);
		    values[i] = new TextField("255");
		    textPanel.add(values[i]);
		    values[i].addActionListener(this);
			}
		add(textPanel, BorderLayout.NORTH);
 	}
	
	public void actionPerformed(ActionEvent e)
	{ Integer intObj;
	  int [] numbers = new int [3];
	  for(int i = 0; i < 3 ; i++) {
	    try { intObj = Integer.valueOf( values[i].getText());
	            numbers[i] = intObj.intValue();
	    	  }
	      catch (NumberFormatException except) {
		   numbers[i] = 0;
		   values[i].setText("0");
		   System.err.println("String entered is not a number");
	      };
       if ((numbers[i] < 0) || (numbers[i] > 255)) {
	        numbers[i] = 0;
	        values[i].setText("0");
		  System.err.println("Number entered is not in range 0-255");
	      }
	     }
	   
	  c.setBackground(new Color (	numbers[0],
	  					numbers[1],
	  					numbers[2])
	  				 );
	  c.repaint();
	}

} // class ColorBars.java

