/*	File: MouseDemo.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.27
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class MouseDemo extends Applet
 implements MouseListener
{   private int xPos, yPos;
	
	public void init() {
	
	setBackground(Color.black);
	addMouseListener(this);
	}

	// Implementing MouseListener
	public void mouseClicked(MouseEvent e) {
		getGraphics().drawString("Mouse Clicked ",10,20);
		}
	
	public void mouseEntered(MouseEvent e) {
		setBackground(Color.white);
		repaint();
	}

	public void mouseExited(MouseEvent e)  {
		setBackground(Color.black);
		repaint();
		
	}

	public void mousePressed(MouseEvent e) {
		Graphics g = getGraphics();
		xPos = e.getX();
		yPos = e.getY();
		g.drawString("Mouse Pressed!", xPos, yPos);
	}

	public void mouseReleased(MouseEvent e) {
		Graphics g = getGraphics();
		g.drawLine(xPos, yPos, e.getX(), e.getY());
	}
} // class MouseDemo

