/*	File: Human.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.33
*/

import java.awt.*;
import java.awt.event.*;

public class Human extends Player implements ActionListener {
	
	public Human(String name, TicTacToe ap) {
		super(name,ap);}
	
	public void takeTurn(){
		// activate all buttons that aren't claimed
	 for(int r=0; r <3; r++)
	  for(int c=0;c <3; c++)
	   {Button b = ap.position(r,c);
	    if (b.isEnabled()) b.addActionListener(this);}
	    
	}
	
	public void actionPerformed(ActionEvent e) {
		// update label
		Button b = (Button)e.getSource();
		b.setLabel(name);
		b.setEnabled(false);
		for(int r=0; r <3; r++)
		 for(int c=0;c <3; c++)
		  {Button bt = ap.position(r,c);
	       if (bt.isEnabled()) bt.removeActionListener(this);}
		ap.nextPlayer();
	}
	
	
	
}

