/*	File: Machine.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.32
*/

import java.awt.*;

public class Machine extends Player{
	
	public Machine(String name, TicTacToe ap) {
		super(name,ap);}
	
	public void takeTurn(){
		// findMove is the "Guts" of decision making
		Button b = findMove();  
		if(b != null) {
			b.setLabel(name);
			b.setEnabled(false);
			ap.nextPlayer();   
		}
		else ap.errorFound("machine player can't make a move!");
	}	

	// This is a very simplistic decision maker. See if you can figure out
	// what it does from reading the code.
	private Button findMove() {
		for(int r=0; r <3; r++)
			for(int c=0;c <3; c++) { 
				Button b = ap.position(r,c);
				if (b.isEnabled()) return b;
		};
		return null;
	}
} // class Machine

