/*	File: TicTacToe.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.30
*/

import java.awt.*;
import java.applet.*;

public class TicTacToe extends Applet {
   // GUI objects
    private Button[][] board = new Button[3][3];
    private Panel p;
    private Label l;
    
   // Game pieces
    private Machine p1;
    private Human p2;
 
   // Score keeping devices
   private Player next = p2;      // p1 will go first (see nextTurn below)
   private Player winner = null;  // gameOver stores winning player here
   private int turns = 0;   // counts turns taken. Game ends when all
                            // squares have been taken.
    
	public void init() {
	 // Create applet layout
	 setLayout(new BorderLayout());
	 
	 // Create panel of buttons
	 p = new Panel();
	 p.setLayout(new GridLayout(3,3));
	 for(int r = 0; r <3; r++)
	  for(int c = 0; c <3; c++)
	   {board[r][c] = new Button("");
     board[r][c].setBackground(Color.white);
	    p.add(board[r][c]);
	   }
	 add(p,BorderLayout.CENTER);
	 
	 // Create label at the bottom
	 l = new Label();
	 add(l,BorderLayout.SOUTH);
	 
	 // Create players, each player needs knowledge of THIS game
	  p1 = new Machine("X", this);  // p1 will be X. 
	  p2 = new Human("0", this);    // p2 will by 0.
	  
	 // Start play
	  nextPlayer();
	  
	}
	
	// Check for winners FIRST! because the first 
        // player could win on the last move.
	// Theoretically turns should never exceed 9, but you never know......
	 public boolean gameOver() {
	 	int r,c;
	 	return (findWinner(p1)) || 
	 		   (findWinner(p2)) ||
	 		   (turns >= 9);
	}
	
	// This is not necessarily the best way to determine a winner. 
	// It creates the side effect of registering the winner in the
	// data field winner. The method showWinner needs this!
	private boolean findWinner(Player p) {
		String name = p.getName();
		for (int r = 0; r < 3; r++)
		 	if (   (board[r][0].getLabel() == name)
		    	&& (board[r][1].getLabel() == name)
		        && (board[r][2].getLabel() == name)
		       ) {winner = p; return true;};
		for (int c = 0; c < 3; c++)
		 	if (   (board[0][c].getLabel() == name)
		   	    && (board[1][c].getLabel() == name)
		        && (board[2][c].getLabel() == name)
		        ) {winner = p; return true;};
		
		if (   (board[0][0].getLabel() == name)
		   	&& (board[1][1].getLabel() == name)
		    && (board[2][2].getLabel() == name)
		   ) {winner = p; return true;};
		
		if (   (board[0][2].getLabel() == name)
		   	&& (board[1][1].getLabel() == name)
		    && (board[2][0].getLabel() == name)
		   ) {winner = p; return true;};
		return false;
 	}
	 
	 public void showWinner() {
	 	if (winner == p1) l.setText("X won");
	 	else if (winner == p2) l.setText("O won");
	 	else l.setText("It was a draw");}
	 
	 public void nextPlayer() {
	  if (gameOver()) showWinner();
	  else {  
	    if (next == p1) next = p2;             // switch between players
	    else next = p1;
	    l.setText("Player: " + next.getName());// Display current player
     	    turns++;                               // Count the number of turns
            next.takeTurn(); 
	  } 
	 }
	
	public void errorFound(String s) {
		l.setText("Fatal error, game terminated: " + s);
	}
	public Button position(int r, int c) {
		return board[r][c];}
} // class TicTacToe


