/*	File: WinDemo.java
	Introduction to Problem Solving with Java, Koffman & Wolz
	Appears in Figure 10.38
*/

import java.awt.*;
import java.awt.event.*;

class WinDemo extends Frame implements WindowListener, ActionListener {
	private MenuItem quit = new MenuItem("Quit");
	private MenuItem add = new MenuItem("Add");
	private MenuItem subtract = new MenuItem("Subtract");
	
	public WinDemo() {
	 super("Window Demo");
	 
	// Create a menu bar
	 MenuBar bar = new MenuBar();
	// Add a "File" menu to it, add a "Quit" menu item to the menu
	// Register as a listener, and add the menu to the bar
	 Menu m = new Menu("File");
	 m.add(quit);
	 quit.addActionListener(this); 
	 bar.add(m);
	 
	// Add a second menu with two items, register the listeners
	// and add the menu to the bar
	 Menu m2 = new Menu("Calculate");
	 m2.add(add);
	 add.addActionListener(this);
	 m2.add(subtract);
	 subtract.addActionListener(this);
	 bar.add(m2);

	 // Add the menubar to the frame
	 setMenuBar(bar);
	
	 addWindowListener(this);
	 setSize(300,300);
	 show();
	 
	}
	
	public void actionPerformed(ActionEvent e) {
		System.out.println(e);
		if (e.getSource() == quit) {
			dispose();
			System.exit(0);
		   }
	}
	
	public void windowClosing(WindowEvent e) {
		System.out.println(e);
		dispose();
	}
	
	public static void main(String args[]) {
		new WinDemo();
	} 
	public void windowActivated(WindowEvent e) {;}
	public void windowClosed(WindowEvent e) {;}
	public void windowDeactivated(WindowEvent e) {;}
	public void windowDeiconified(WindowEvent e) {;}
	public void windowIconified(WindowEvent e) {;}
	public void windowOpened(WindowEvent e) {;}
}
