/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.13.

   Returns true if its array arguments are equal.
   Returns false if they are not.
*/

package simpleIO;

public class IntArray {

  private IntArray() {}

     public static boolean sameArray(int[] a, int[] b) {
        // Check for unequal lengths.
        if (a.length != b.length)
           return false;

        // Return false if any pair doesn't match.
        for (int i = 0; i < a.length; i++)
           if (a[i] != b[i])
              return false;

        // All pairs matched.
        return true;
     }

	public static int findPosMin(int[] x, int fill) {
  	 int posMinSoFar = fill;
  	 for (int i = fill + 1; i < x.length; i++)
     	 if (x[i] < x[posMinSoFar])
     	    posMinSoFar = i;

  	 return posMinSoFar;
	}


//-------------------------------------------------------------
// INSERTIONS FROM CHAPTER 11
//-------------------------------------------------------------


/*	Part of class IntArray in package simpleMath.
	Developed for Problem Solving with Java, Koffman & Wolz.
	Appears in Fig. 11.9.

	Finds the sum of first n elements of array x.
	Precondition : Array x is defined and n >= 1.
	Postcondition: Returns sum of first n elements of x.
*/
public static int findSum(int[] x, int n) {
	if (n <= 1)
		return x[0];
	else
		return x[n-1] + findSum(x, n-1);
}


/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 11.11.

   Searches array elements x[0] through x[n-1] for target.
   Precondition: target, n, and array x are defined & n >= 0.
   Postcondition: Returns position of its last occurrence
                  if target is found in
                  array x; otherwise, returns -1.
*/
public static int search(int[] x, int target, int n) {
	if (n == 0)
		return -1;         // target not in empty array
	else if (x[n-1] == target)
		return n-1;        // found! - return location.
	else  //Search rest of array.
		return search(x, target, n-1);
}


/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 11.13.

   Searches array elements x[0] through x[n-1] for target.
   Precondition: target, n, and array x are defined & n >= 0.
   Postcondition: Returns position of its last occurrence
                  if target is found in
                  array x; otherwise, returns -1.
*/
public static int searchIt (int[] x, int target, int n) {
	for (int i = n-1; i >= 0; i--)      
		if (x[i] == target)
			return i;    // found! - return location.

	// assert: All elements examined & target not found.
	return -1;
}


/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 11.14.

   Compares two n-element arrays.
   precondition : Arrays x & y are defined and n > 0.
   postcondition: Returns true if arrays x & y are equal;
                    otherwise, returns false.
*/
public static boolean isEqual (int[] x, int[] y, int n) {
	if (x.length != y.length)
		return false;          // array sizes unequal
	else if (n == 1)
		return (x[0] == y[0]); // Compare 1-element arrays.
	else if (x[n-1] != y[n-1])
		return false;          // Found an unequal pair.
	else  // Compare rest of arrays.
		return isEqual(x, y, n-1); 
}


/* Part of class IntArray in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 11.20.

   Searches for target in elements first through last of 
     array table.
   Precondition : The elements of table are sorted &
                     first and last are defined.
   Postcondition: If target is in the array, return its
                     position; otherwise, returns -1.
*/
public static int binSearch (int[] table, 
                             int target,
                             int first,
                             int last) {
	int middle = (first + last) / 2; // middle of array

	if (first > last)            
		return -1;                  // unsuccessful search
	else if (target == table[middle])
		return middle;              // successful search
	else if (target < table[middle])
		return binSearch(table, target, first, middle-1);
	else  // search upper half of array 
		return binSearch(table, target, middle+1, last);
}


//---------------------------------------------------------
// INSERTIONS FROM CHAPTER 7
//---------------------------------------------------------


/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.15.

   Returns a reference to an array that contains the sum of 
   corresponding pairs of elements of its array arguments.
   The first element in the result array is a[0] + b[0],
   the second element is a[1] + b[1], ... .
*/
public static int[] addArray(int[] a, int[] b) {
   int[] c = new int[Math.min(a.length, b.length)];

   for (int i = 0; i < c.length; i++)
      c[i] = a[i] + b[i];

   return c;
}


/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.16.

   Searches for target in its array argument.
   Returns the index of the first occurrence or -1 if 
   target is not found.
*/
    public static int search(int[] x, int target) {
        for (int i = 0; i < x.length; i++)
            if (x[i] == target)
                return i;        //index of target

        // All elements tested without success.
        return -1;
    }


/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.18.

   Sorts the data in its array argument so that the
   values in the array are in increasing order.
   Calls method findPosMin
*/
public static void selectSort(int[] x) {

   int posMin;       //index of next smallest element
   int temp;         //temporary value for exchange

   for (int fill = 0; fill < x.length-1; fill++) {
      /* invariant:
            The elements in x[0] through x[fill-1] are in
            their proper place and fill < x.length.
      */
      //Find index of smallest element in subarray 
      //  starting at element x[fill].
      posMin = findPosMin(x, fill);

      //Exchange elements with indices fill and posMin.
      if (posMin != fill) {
        temp = x[fill];
        x[fill] = x[posMin];
        x[posMin] = temp;
      }
   }
}


/* Part of class IntArray in package SimpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 7.19.

   Returns the median value in its array argument.
*/
public static int findMedian(int x[]) {
	// Create a copy of array x.
	int[] copyX = new int[x.length];
	System.arraycopy(x, 0, copyX, 0, x.length); 

	selectSort(copyX);  // Sort array copyX

	return copyX[x.length / 2];
}

}



