//Figure 4.21 Class MyMath with Methods randIntRange and aveTwo

package simpleMath;

import simpleMath.*;

public class MyMath {
    //Returns a random integer in the range low to high, inclusive.
    public static int randomIntRange(int low, int high) {
        return (int) ((high - low + 1) * Math.random() + low);
    }

    //Returns the average of its two arguments
    public static double aveTwo(double first, double second) {
        return (first + second) / 2.0;
    }

//------------------------------------------------------------
// INSERTIONS FROM CHAPTER 11
//------------------------------------------------------------

/* Part of class MyMath in package simpleMath.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 11.1.

   Raises m to the power n.
   Precondition : m and n are defined and n > 0.
   Postcondition: Returns m raised to the power n.
*/
public static int power(int m, int n) {
	if (n <= 1)
		return m;                     // stopping case
	else
		return m * power(m, n-1);     // recursive step
}


/*	Part of class MyMath in package simpleMath.
	Developed for Problem Solving with Java, Koffman & Wolz.
	Appears in Fig. 11.4.

	Finds the greatest common divisor of m and n.
	Precondition : m and n are defined and both are > 0.
	Postcondition: Returns greatest common divisor of m & n.
*/
public static int gcd(int m, int n) {
	if (m < n)
		return gcd(n, m);
	else if (m % n == 0)
		return n;
	else
		return gcd(n, m % n);
}


/*	Part of class MyMath in package simpleMath.
	Developed for Problem Solving with Java, Koffman & Wolz.
	Appears in Fig. 11.5.

	Computes the nth Fibonacci number.
	Precondition : n is defined and n > 0.
	Postcondition: Returns the nth Fibonacci number.
*/
public static int fibonacci(int n) {
	if (n <= 2)
		return 1;
	else
		return fibonacci(n-2) + fibonacci(n-1);
}


} // class MyMath

